/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.config;

import de.kosit.validationtool.config.Builder;
import de.kosit.validationtool.config.ReportBuilder;
import de.kosit.validationtool.impl.ContentRepository;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.model.scenarios.CreateReportType;
import de.kosit.validationtool.model.scenarios.ScenarioType;
import java.net.URI;
import java.nio.file.Path;
import org.apache.commons.lang3.tuple.Pair;

public class FallbackBuilder
implements Builder<Scenario> {
    private final ReportBuilder internal = new ReportBuilder().name("fallback");

    @Override
    public Result<Scenario, String> build(ContentRepository repository) {
        Result result;
        ScenarioType object = FallbackBuilder.createObject();
        Result<Pair<CreateReportType, Scenario.Transformation>, String> build = this.internal.build(repository);
        if (build.isValid()) {
            object.setCreateReport(build.getObject().getLeft());
            Scenario s = new Scenario(object);
            s.setFallback(true);
            s.setFactory(repository.getResolvingConfigurationStrategy());
            s.setUriResolver(repository.getResolver());
            s.setUnparsedTextURIResolver(repository.getUnparsedTextURIResolver());
            s.setReportTransformation(build.getObject().getRight());
            result = new Result(s);
        } else {
            result = new Result(build.getErrors());
        }
        return result;
    }

    private static ScenarioType createObject() {
        ScenarioType t = new ScenarioType();
        t.setName("Fallback-Scenario");
        t.setMatch("count(/)<0");
        t.setAcceptMatch("count(/)<0");
        return t;
    }

    public FallbackBuilder source(String source) {
        this.internal.source(source);
        return this;
    }

    public FallbackBuilder source(URI source) {
        this.internal.source(source);
        return this;
    }

    public FallbackBuilder source(Path source) {
        this.internal.source(source);
        return this;
    }

    public FallbackBuilder name(String name) {
        this.internal.name(name);
        return this;
    }
}

