/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.input;

import de.kosit.validationtool.impl.input.AbstractInput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class ByteArrayInput
extends AbstractInput {
    private final byte[] content;
    private final String name;
    private final String digestAlgorithm;

    @Override
    public long getLength() {
        return this.content != null ? (long)this.content.length : 0L;
    }

    @Override
    public Source getSource() {
        InputStream stream = this.wrap(new ByteArrayInputStream(this.content));
        return new StreamSource(stream, this.getName());
    }

    public byte[] getContent() {
        return this.content;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public ByteArrayInput(byte[] content, String name, String digestAlgorithm) {
        this.content = content;
        this.name = name;
        this.digestAlgorithm = digestAlgorithm;
    }
}

