/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl;

import de.kosit.validationtool.model.reportInput.XMLSyntaxError;
import de.kosit.validationtool.model.reportInput.XMLSyntaxErrorSeverity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringJoiner;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.s9api.MessageListener2;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CollectingErrorEventHandler
implements ValidationEventHandler,
ErrorHandler,
MessageListener2,
ErrorListener {
    private static final int DEFAULT_ABORT_COUNT = 50;
    private static final int stopProcessCount = 50;
    private final Collection<XMLSyntaxError> errors = new ArrayList<XMLSyntaxError>();

    private static XMLSyntaxError createError(XMLSyntaxErrorSeverity severity, String message) {
        XMLSyntaxError e = new XMLSyntaxError();
        e.setSeverityCode(severity);
        e.setMessage(message);
        return e;
    }

    private static XMLSyntaxError createError(XMLSyntaxErrorSeverity severity, SAXParseException exception) {
        XMLSyntaxError e = CollectingErrorEventHandler.createError(severity, exception.getMessage());
        e.setRowNumber(exception.getLineNumber());
        e.setColumnNumber(exception.getColumnNumber());
        return e;
    }

    private static XMLSyntaxError createError(XMLSyntaxErrorSeverity severity, TransformerException exception) {
        XMLSyntaxError e = CollectingErrorEventHandler.createError(severity, exception.getMessage());
        if (exception.getLocator() != null) {
            e.setRowNumber(exception.getLocator().getLineNumber());
            e.setColumnNumber(exception.getLocator().getColumnNumber());
        }
        return e;
    }

    private static XMLSyntaxErrorSeverity translateSeverity(int severity) {
        switch (severity) {
            case 0: {
                return XMLSyntaxErrorSeverity.SEVERITY_WARNING;
            }
            case 1: {
                return XMLSyntaxErrorSeverity.SEVERITY_ERROR;
            }
            case 2: {
                return XMLSyntaxErrorSeverity.SEVERITY_FATAL_ERROR;
            }
        }
        throw new IllegalArgumentException("Unknown severity level " + severity);
    }

    @Override
    public boolean handleEvent(ValidationEvent event) {
        XMLSyntaxError e = CollectingErrorEventHandler.createError(CollectingErrorEventHandler.translateSeverity(event.getSeverity()), event.getMessage());
        e.setColumnNumber(event.getLocator().getColumnNumber());
        e.setRowNumber(event.getLocator().getLineNumber());
        this.errors.add(e);
        return 50 != this.errors.size();
    }

    public boolean hasErrors() {
        return this.hasEvents() && this.errors.stream().anyMatch(e -> e.getSeverityCode() != XMLSyntaxErrorSeverity.SEVERITY_WARNING);
    }

    public boolean hasEvents() {
        return !this.errors.isEmpty();
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.errors.add(CollectingErrorEventHandler.createError(XMLSyntaxErrorSeverity.SEVERITY_WARNING, exception));
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.errors.add(CollectingErrorEventHandler.createError(XMLSyntaxErrorSeverity.SEVERITY_ERROR, exception));
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.errors.add(CollectingErrorEventHandler.createError(XMLSyntaxErrorSeverity.SEVERITY_FATAL_ERROR, exception));
    }

    @Override
    public void message(XdmNode content, QName errorCode, boolean terminate, SourceLocator locator) {
        XMLSyntaxError e = new XMLSyntaxError();
        if (locator != null) {
            e.setColumnNumber(locator.getColumnNumber());
            e.setRowNumber(locator.getLineNumber());
        }
        e.setMessage("Error procesing" + content.getStringValue());
        e.setSeverityCode(terminate ? XMLSyntaxErrorSeverity.SEVERITY_FATAL_ERROR : XMLSyntaxErrorSeverity.SEVERITY_WARNING);
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        this.errors.add(CollectingErrorEventHandler.createError(XMLSyntaxErrorSeverity.SEVERITY_WARNING, exception));
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        this.errors.add(CollectingErrorEventHandler.createError(XMLSyntaxErrorSeverity.SEVERITY_ERROR, exception));
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        this.errors.add(CollectingErrorEventHandler.createError(XMLSyntaxErrorSeverity.SEVERITY_FATAL_ERROR, exception));
    }

    public String getErrorDescription() {
        StringJoiner joiner = new StringJoiner("\n");
        this.errors.forEach(e -> joiner.add(e.getSeverityCode().value() + " " + e.getMessage() + " At row " + e.getRowNumber() + " at pos " + e.getColumnNumber()));
        return joiner.toString();
    }

    public Collection<XMLSyntaxError> getErrors() {
        return this.errors;
    }
}

