/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl;

import de.kosit.validationtool.api.ResolvingConfigurationStrategy;
import de.kosit.validationtool.model.scenarios.ResourceType;
import de.kosit.validationtool.model.scenarios.ScenarioType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.transform.URIResolver;
import javax.xml.validation.Schema;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XsltExecutable;

public class Scenario {
    private final ScenarioType configuration;
    private Schema schema;
    private boolean fallback;
    private XPathExecutable matchExecutable;
    private XPathExecutable acceptExecutable;
    private ResolvingConfigurationStrategy factory;
    private URIResolver uriResolver;
    private UnparsedTextURIResolver unparsedTextURIResolver;
    private List<Transformation> schematronValidations;
    private Transformation reportTransformation;

    public List<Transformation> getSchematronValidations() {
        return this.schematronValidations == null ? Collections.emptyList() : this.schematronValidations;
    }

    public String getName() {
        return this.configuration.getName();
    }

    public XPathSelector getMatchSelector() {
        if (this.matchExecutable == null) {
            throw new IllegalStateException("No match executable supplied");
        }
        return this.matchExecutable.load();
    }

    public Optional<XPathSelector> getAcceptSelector() {
        XPathSelector selector = this.acceptExecutable != null ? this.acceptExecutable.load() : null;
        return Optional.ofNullable(selector);
    }

    public Scenario(ScenarioType configuration) {
        this.configuration = configuration;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setFallback(boolean fallback) {
        this.fallback = fallback;
    }

    public void setMatchExecutable(XPathExecutable matchExecutable) {
        this.matchExecutable = matchExecutable;
    }

    public void setAcceptExecutable(XPathExecutable acceptExecutable) {
        this.acceptExecutable = acceptExecutable;
    }

    public void setFactory(ResolvingConfigurationStrategy factory) {
        this.factory = factory;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver unparsedTextURIResolver) {
        this.unparsedTextURIResolver = unparsedTextURIResolver;
    }

    public void setReportTransformation(Transformation reportTransformation) {
        this.reportTransformation = reportTransformation;
    }

    public ScenarioType getConfiguration() {
        return this.configuration;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean isFallback() {
        return this.fallback;
    }

    public XPathExecutable getMatchExecutable() {
        return this.matchExecutable;
    }

    public XPathExecutable getAcceptExecutable() {
        return this.acceptExecutable;
    }

    public ResolvingConfigurationStrategy getFactory() {
        return this.factory;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.unparsedTextURIResolver;
    }

    public Transformation getReportTransformation() {
        return this.reportTransformation;
    }

    public void setSchematronValidations(List<Transformation> schematronValidations) {
        this.schematronValidations = schematronValidations;
    }

    public static class Transformation {
        private XsltExecutable executable;
        private ResourceType resourceType;

        public XsltExecutable getExecutable() {
            return this.executable;
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }

        public void setExecutable(XsltExecutable executable) {
            this.executable = executable;
        }

        public void setResourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
        }

        public Transformation(XsltExecutable executable, ResourceType resourceType) {
            this.executable = executable;
            this.resourceType = resourceType;
        }
    }
}

