/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl;

import de.kosit.validationtool.impl.CollectingErrorEventHandler;
import de.kosit.validationtool.model.reportInput.ObjectFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringJoiner;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionService {
    private static final Logger log = LoggerFactory.getLogger(ConversionService.class);
    private static final int MAX_LOG_CONTENT = 50;
    private JAXBContext jaxbContext;

    public JAXBContext getJaxbContext() {
        if (this.jaxbContext == null) {
            this.initialize();
        }
        return this.jaxbContext;
    }

    private static <T> QName createQName(T model) {
        return new QName(model.getClass().getSimpleName().toLowerCase());
    }

    private void checkInputEmpty(URI xml) {
        if (xml == null) {
            throw new ConversionExeption("Can not unmarshal from empty input");
        }
    }

    private <T> void checkTypeEmpty(Class<T> type) {
        if (type == null) {
            throw new ConversionExeption("Can not unmarshal without type information. Need to specify a target type");
        }
    }

    public void initialize() {
        ArrayList<Package> p = new ArrayList<Package>();
        p.add(ObjectFactory.class.getPackage());
        p.add(de.kosit.validationtool.model.scenarios.ObjectFactory.class.getPackage());
        this.initialize(p);
    }

    public void initialize(Package ... context) {
        this.initialize(Arrays.asList(context));
    }

    public void initialize(Collection<Package> context) {
        String[] packages = context != null ? (String[])context.stream().map(Package::getName).toArray(String[]::new) : new String[]{};
        StringJoiner joiner = new StringJoiner(":");
        Arrays.stream(packages).forEach(joiner::add);
        this.initialize(joiner.toString());
    }

    private void initialize(String contextPath) {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)contextPath, (ClassLoader)ConversionService.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new IllegalStateException(String.format("Can not create JAXB context for given context: %s", contextPath), e);
        }
    }

    public <T> T readXml(URI xml, Class<T> type) {
        return this.readXml(xml, type, null, null);
    }

    public <T> T readXml(URI xml, Class<T> type, Schema schema) {
        return this.readXml(xml, type, schema, null);
    }

    public <T> T readXml(URI xml, Class<T> type, Schema schema, ValidationEventHandler handler) {
        this.checkInputEmpty(xml);
        this.checkTypeEmpty(type);
        CollectingErrorEventHandler defaultHandler = null;
        ValidationEventHandler handler2Use = handler;
        if (schema != null && handler == null) {
            defaultHandler = new CollectingErrorEventHandler();
            handler2Use = defaultHandler;
        }
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newFactory();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = inputFactory.createXMLStreamReader(new StreamSource(xml.toASCIIString()));
            Unmarshaller u = this.getJaxbContext().createUnmarshaller();
            u.setSchema(schema);
            u.setEventHandler(handler2Use);
            Object value = u.unmarshal(xsr, type).getValue();
            if (defaultHandler != null && defaultHandler.hasErrors()) {
                throw new ConversionExeption(String.format("Schema errors while reading content from %s: %s", xml, defaultHandler.getErrorDescription()));
            }
            return (T)value;
        }
        catch (JAXBException | XMLStreamException e) {
            throw new ConversionExeption(String.format("Can not unmarshal to type %s from %s", type.getSimpleName(), xml.toString()), (Exception)e);
        }
    }

    public <T> String writeXml(T model) {
        return this.writeXml(model, null, null);
    }

    public <T> String writeXml(T model, Schema schema, ValidationEventHandler handler) {
        String string;
        if (model == null) {
            throw new ConversionExeption("Can not serialize null");
        }
        StringWriter w = new StringWriter();
        try {
            JAXBIntrospector introspector = this.getJaxbContext().createJAXBIntrospector();
            Marshaller marshaller = this.getJaxbContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setSchema(schema);
            marshaller.setEventHandler(handler);
            XMLOutputFactory xof = XMLOutputFactory.newFactory();
            XMLStreamWriter xmlStreamWriter = xof.createXMLStreamWriter(w);
            if (null == introspector.getElementName(model)) {
                JAXBElement jaxbElement = new JAXBElement(ConversionService.createQName(model), model.getClass(), model);
                marshaller.marshal((Object)jaxbElement, xmlStreamWriter);
            } else {
                marshaller.marshal(model, xmlStreamWriter);
            }
            xmlStreamWriter.flush();
            string = w.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    w.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException | XMLStreamException e) {
                throw new ConversionExeption(String.format("Error serializing Object %s", model.getClass().getName()), (Exception)e);
            }
        }
        w.close();
        return string;
    }

    public <T> T readDocument(Source source, Class<T> type) {
        try {
            Unmarshaller u = this.getJaxbContext().createUnmarshaller();
            return (T)u.unmarshal(source, type).getValue();
        }
        catch (JAXBException e) {
            throw new ConversionExeption(String.format("Can not unmarshal to type %s: %s", type.getSimpleName(), StringUtils.abbreviate(source.getSystemId(), 50)), (Exception)((Object)e));
        }
    }

    public class ConversionExeption
    extends RuntimeException {
        public ConversionExeption(String message, Exception cause) {
            super(message, cause);
        }

        public ConversionExeption(String message) {
            super(message);
        }
    }
}

