/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class EngineInformation {
    private static final Properties PROPERTIES = new Properties();

    private EngineInformation() {
    }

    public static String getVersion() {
        return PROPERTIES.getProperty("project_version");
    }

    public static String getName() {
        return PROPERTIES.getProperty("engine_name");
    }

    public static String getFrameworkVersion() {
        return PROPERTIES.getProperty("framework_version");
    }

    public static String getFrameworkMajorVersion() {
        return EngineInformation.getFrameworkVersion().substring(0, 1);
    }

    public static String getBuild() {
        return PROPERTIES.getProperty("build_number");
    }

    public static String getFrameworkNamespace() {
        return "http://www.xoev.de/de/validator/framework/" + EngineInformation.getFrameworkMajorVersion() + "/createreportinput";
    }

    static {
        try (InputStream input = EngineInformation.class.getClassLoader().getResourceAsStream("app-info.properties");){
            if (input != null) {
                PROPERTIES.load(input);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not engine information", e);
        }
    }
}

