/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.xml;

import java.io.Reader;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.trans.XPathException;

public class ProcessorProvider {
    protected static final String DISSALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";
    private static Processor processor;

    private static String encode(String input) {
        return URLEncoder.encode(input, StandardCharsets.UTF_8.name());
    }

    public static Processor getProcessor() {
        if (processor == null) {
            processor = ProcessorProvider.createProcessor();
        }
        return processor;
    }

    private static Processor createProcessor() {
        Processor processor = new Processor(false);
        SecureUriResolver resolver = new SecureUriResolver();
        processor.getUnderlyingConfiguration().setCollectionFinder(resolver);
        processor.getUnderlyingConfiguration().setOutputURIResolver(resolver);
        processor.getUnderlyingConfiguration().setUnparsedTextURIResolver(resolver);
        processor.setConfigurationProperty(Feature.DTD_VALIDATION, false);
        processor.setConfigurationProperty(Feature.ENTITY_RESOLVER_CLASS, "");
        processor.setConfigurationProperty(Feature.XINCLUDE, false);
        processor.setConfigurationProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS, false);
        processor.setConfigurationProperty("http://saxon.sf.net/feature/parserFeature?uri=" + ProcessorProvider.encode(FEATURE_SECURE_PROCESSING), (Object)true);
        processor.setConfigurationProperty("http://saxon.sf.net/feature/parserFeature?uri=" + ProcessorProvider.encode(DISSALLOW_DOCTYPE_DECL_FEATURE), (Object)true);
        processor.setConfigurationProperty("http://saxon.sf.net/feature/parserFeature?uri=" + ProcessorProvider.encode(LOAD_EXTERNAL_DTD_FEATURE), (Object)false);
        processor.setConfigurationProperty("http://saxon.sf.net/feature/parserFeature?uri=" + ProcessorProvider.encode("http://javax.xml.XMLConstants/property/accessExternalDTD"), (Object)false);
        return processor;
    }

    private static class SecureUriResolver
    implements CollectionFinder,
    OutputURIResolver,
    UnparsedTextURIResolver {
        public static final String MESSAGE = "Configuration error. Resolving ist not allowed";

        private SecureUriResolver() {
        }

        @Override
        public OutputURIResolver newInstance() {
            return this;
        }

        @Override
        public Result resolve(String href, String base) throws TransformerException {
            throw new IllegalStateException(MESSAGE);
        }

        @Override
        public void close(Result result) throws TransformerException {
            throw new IllegalStateException(MESSAGE);
        }

        @Override
        public Reader resolve(URI absoluteURI, String encoding, Configuration config) throws XPathException {
            throw new IllegalStateException(MESSAGE);
        }

        @Override
        public ResourceCollection findCollection(XPathContext context, String collectionURI) throws XPathException {
            throw new IllegalStateException(MESSAGE);
        }
    }
}

