/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.cmd.NamingStrategy;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultNamingStrategy
implements NamingStrategy {
    private String prefix;
    private String postfix;

    @Override
    public String createName(String name) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Can not generate name based on null input");
        }
        String base = FilenameUtils.isExtension(name.toLowerCase(), "xml") ? FilenameUtils.getBaseName(name) : name;
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotEmpty(this.prefix)) {
            result.append(this.prefix).append("-");
        }
        result.append(base);
        if (StringUtils.isNotEmpty(this.postfix)) {
            result.append("-").append(this.postfix);
        } else if (StringUtils.isEmpty(this.prefix)) {
            result.append("-").append("report");
        }
        result.append(".xml");
        return result.toString();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }
}

