/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl;

import de.kosit.validationtool.api.Check;
import de.kosit.validationtool.api.Configuration;
import de.kosit.validationtool.api.Input;
import de.kosit.validationtool.api.Result;
import de.kosit.validationtool.api.XmlError;
import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.impl.DateFactory;
import de.kosit.validationtool.impl.DefaultResult;
import de.kosit.validationtool.impl.EngineInformation;
import de.kosit.validationtool.impl.HtmlExtractor;
import de.kosit.validationtool.impl.ScenarioRepository;
import de.kosit.validationtool.impl.SchemaProvider;
import de.kosit.validationtool.impl.tasks.CheckAction;
import de.kosit.validationtool.impl.tasks.ComputeAcceptanceAction;
import de.kosit.validationtool.impl.tasks.CreateDocumentIdentificationAction;
import de.kosit.validationtool.impl.tasks.CreateReportAction;
import de.kosit.validationtool.impl.tasks.DocumentParseAction;
import de.kosit.validationtool.impl.tasks.ScenarioSelectionAction;
import de.kosit.validationtool.impl.tasks.SchemaValidationAction;
import de.kosit.validationtool.impl.tasks.SchematronValidationAction;
import de.kosit.validationtool.impl.tasks.ValidateReportInputAction;
import de.kosit.validationtool.impl.xml.ProcessorProvider;
import de.kosit.validationtool.model.reportInput.CreateReportInput;
import de.kosit.validationtool.model.reportInput.EngineType;
import de.kosit.validationtool.model.reportInput.XMLSyntaxError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.saxon.s9api.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCheck
implements Check {
    private static final Logger log = LoggerFactory.getLogger(DefaultCheck.class);
    private final ConversionService conversionService;
    private final List<Configuration> configuration;
    private final List<CheckAction> checkSteps;
    private final Processor processor;

    public DefaultCheck(Configuration ... configuration) {
        this(ProcessorProvider.getProcessor(), configuration);
    }

    public DefaultCheck(Processor processor, Configuration ... configuration) {
        this.configuration = Arrays.asList(configuration);
        this.processor = processor;
        this.conversionService = new ConversionService();
        this.checkSteps = new ArrayList<CheckAction>();
        this.checkSteps.add(new DocumentParseAction(processor));
        this.checkSteps.add(new CreateDocumentIdentificationAction());
        this.checkSteps.add(new ScenarioSelectionAction(new ScenarioRepository(configuration)));
        this.checkSteps.add(new SchemaValidationAction(processor));
        this.checkSteps.add(new SchematronValidationAction(this.conversionService));
        this.checkSteps.add(new ValidateReportInputAction(this.conversionService, SchemaProvider.getReportInputSchema()));
        this.checkSteps.add(new CreateReportAction(processor, this.conversionService));
        this.checkSteps.add(new ComputeAcceptanceAction());
    }

    protected static CreateReportInput createReport() {
        CreateReportInput type = new CreateReportInput();
        EngineType e = new EngineType();
        e.setName(EngineInformation.getName() + " " + EngineInformation.getVersion());
        type.setEngine(e);
        type.setTimestamp(DateFactory.createTimestamp());
        type.setFrameworkVersion(EngineInformation.getFrameworkVersion());
        return type;
    }

    protected boolean isSuccessful(Map<String, Result> results) {
        return results.entrySet().stream().allMatch(e -> ((Result)e.getValue()).isAcceptable());
    }

    @Override
    public Result checkInput(Input input) {
        CheckAction.Bag t = new CheckAction.Bag(input, DefaultCheck.createReport());
        return this.runCheckInternal(t);
    }

    protected Result runCheckInternal(CheckAction.Bag t) {
        long started = System.currentTimeMillis();
        log.info("Checking content of {}", (Object)t.getInput().getName());
        for (CheckAction action : this.checkSteps) {
            long start = System.currentTimeMillis();
            if (!action.isSkipped(t)) {
                action.check(t);
            }
            log.debug("Step {} finished in {}ms", (Object)action.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - start));
        }
        t.setFinished(true);
        log.info("Finished check of {} in {}ms\n", (Object)t.getInput().getName(), (Object)(System.currentTimeMillis() - started));
        return this.createResult(t);
    }

    private Result createResult(CheckAction.Bag t) {
        DefaultResult result = new DefaultResult(t.getReport(), t.getAcceptStatus(), new HtmlExtractor(this.processor));
        result.setWellformed(t.getParserResult().isValid());
        result.setReportInput(t.getReportInput());
        if (t.getSchemaValidationResult() != null) {
            result.setSchemaViolations(DefaultCheck.convertErrors(t.getSchemaValidationResult().getErrors()));
        }
        result.setProcessingSuccessful(!t.isStopped() && t.isFinished());
        result.setSchematronResult(t.getReportInput().getValidationResultsSchematron().stream().filter(e -> e.getResults() != null).map(e -> e.getResults().getSchematronOutput()).collect(Collectors.toList()));
        return result;
    }

    private static List<XmlError> convertErrors(Collection<XMLSyntaxError> errors) {
        return (List)errors;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public List<Configuration> getConfiguration() {
        return this.configuration;
    }

    public List<CheckAction> getCheckSteps() {
        return this.checkSteps;
    }

    public Processor getProcessor() {
        return this.processor;
    }
}

