/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.api.Configuration;
import de.kosit.validationtool.api.Input;
import de.kosit.validationtool.api.Result;
import de.kosit.validationtool.api.XmlError;
import de.kosit.validationtool.cmd.report.Grid;
import de.kosit.validationtool.cmd.report.Justify;
import de.kosit.validationtool.cmd.report.Line;
import de.kosit.validationtool.impl.DefaultCheck;
import de.kosit.validationtool.impl.tasks.CheckAction;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.saxon.s9api.Processor;
import org.fusesource.jansi.AnsiRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalCheck
extends DefaultCheck {
    private static final Logger log = LoggerFactory.getLogger(InternalCheck.class);
    private int checkAssertions = 0;
    private int failedAssertions = 0;

    InternalCheck(Processor processor, Configuration ... configuration) {
        super(processor, configuration);
    }

    private static String createStatusLine(Map<String, Result> results) {
        long acceptable = results.entrySet().stream().filter(e -> ((Result)e.getValue()).isAcceptable()).count();
        long rejected = results.entrySet().stream().filter(e -> !((Result)e.getValue()).isAcceptable()).count();
        long errors = results.entrySet().stream().filter(e -> !((Result)e.getValue()).isProcessingSuccessful()).count();
        Line line = new Line();
        line.add("Acceptable: ").add((Object)acceptable, AnsiRenderer.Code.GREEN);
        line.add(" Rejected: ").add((Object)rejected, AnsiRenderer.Code.RED);
        if (errors > 0L) {
            line.add(" Processing errors: ").add((Object)errors, AnsiRenderer.Code.RED);
        }
        return line.render(true, false);
    }

    private static Grid createResultGrid(Map<String, Result> results) {
        Grid grid = new Grid(new Grid.ColumnDefinition("File", 60, 10, 1), new Grid.ColumnDefinition("Schema", 7).justify(Justify.CENTER), new Grid.ColumnDefinition("Schematron", 10).justify(Justify.CENTER), new Grid.ColumnDefinition("Acceptance", 10, 5).justify(Justify.CENTER), new Grid.ColumnDefinition("Error/Description", 60, 20, 3));
        results.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            Result value = (Result)e.getValue();
            AnsiRenderer.Code textcolor = value.isAcceptable() ? AnsiRenderer.Code.GREEN : AnsiRenderer.Code.RED;
            grid.addCell(e.getKey(), textcolor);
            grid.addCell(value.isSchemaValid() ? "Y" : "N", textcolor);
            grid.addCell(value.isSchematronValid() ? "Y" : "N", textcolor);
            grid.addCell((Object)value.getAcceptRecommendation(), textcolor);
            grid.addCell(InternalCheck.joinErrors(value));
        });
        return grid;
    }

    private static String joinErrors(Result value) {
        StringBuilder b = new StringBuilder();
        b.append(String.join((CharSequence)";", value.getProcessingErrors()));
        if (value.getSchemaViolations() != null && !value.getSchemaViolations().isEmpty()) {
            b.append(b.length() > 0 ? ";" : "");
            b.append(value.getSchemaViolations().stream().map(XmlError::getMessage).collect(Collectors.joining(";")));
        }
        if (value.getSchematronResult() != null && !value.getSchematronResult().isEmpty()) {
            b.append(b.length() > 0 ? ";" : "");
            b.append(value.getSchematronResult().stream().flatMap(e -> e.getMessages().stream()).collect(Collectors.joining(";")));
        }
        return b.toString();
    }

    @Override
    public Result checkInput(Input input) {
        CheckAction.Bag bag = new CheckAction.Bag(input, InternalCheck.createReport());
        Result result = this.runCheckInternal(bag);
        if (bag.getAssertionResult() != null) {
            this.checkAssertions += bag.getAssertionResult().getObject().intValue();
            this.failedAssertions += bag.getAssertionResult().getErrors().size();
        }
        return result;
    }

    void printResults(Map<String, Result> results) {
        PrintWriter writer = new PrintWriter(System.out);
        writer.write("Results:\n");
        writer.write(InternalCheck.createResultGrid(results).render());
        writer.write(InternalCheck.createStatusLine(results));
        writer.write(this.createAssertionStatus());
        writer.flush();
    }

    private String createAssertionStatus() {
        Line line = new Line();
        if (this.failedAssertions > 0) {
            log.error("Assertion check failed.\n\nAssertions run: {}, Assertions failed: {}\n", (Object)this.checkAssertions, (Object)this.failedAssertions);
            line.add(MessageFormat.format("Assertions run: {0}, Assertions failed: ", this.checkAssertions));
            line.add((Object)this.failedAssertions, AnsiRenderer.Code.RED);
        } else if (this.checkAssertions > 0) {
            log.info("Assertion check successful.\n\nAssertions run: {}, Assertions failed: {}\n", (Object)this.checkAssertions, (Object)this.failedAssertions);
            line.add(MessageFormat.format("Assertions run: {0}, Assertions failed: {1}", this.checkAssertions, this.failedAssertions));
        }
        return line.render(true, false);
    }

    @Override
    public boolean isSuccessful(Map<String, Result> results) {
        if (this.checkAssertions > 0) {
            return this.failedAssertions == 0;
        }
        return super.isSuccessful(results);
    }

    public int getNotAcceptableCount(Map<String, Result> results) {
        return (int)((long)this.failedAssertions + results.values().stream().filter(e -> !e.isAcceptable()).count());
    }
}

