/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.model;

import de.kosit.validationtool.api.XmlError;
import de.kosit.validationtool.model.reportInput.XMLSyntaxErrorSeverity;
import org.slf4j.Logger;

public abstract class BaseXMLSyntaxError
implements XmlError {
    public void log(Logger logger) {
        String msgTemplate = "{} At row {} at pos {}";
        Object[] params = new Object[]{this.getMessage(), this.getRowNumber(), this.getColumnNumber()};
        if (this.getSeverityCode() == XMLSyntaxErrorSeverity.SEVERITY_WARNING) {
            logger.warn("{} At row {} at pos {}", params);
        } else {
            logger.error("{} At row {} at pos {}", params);
        }
    }

    public String toString() {
        return String.format("%s At row %s at pos %s", this.getMessage(), this.getRowNumber(), this.getColumnNumber());
    }

    public abstract XMLSyntaxErrorSeverity getSeverityCode();

    @Override
    public XmlError.Severity getSeverity() {
        XMLSyntaxErrorSeverity code = this.getSeverityCode();
        return code != null ? XmlError.Severity.valueOf(code.name()) : null;
    }
}

