<?php

/* XRechnung Support Version 3.0     (c) 2024 SPE Systemhaus GmbH */

require "factXrech-class.php";

chdir (dirname(__FILE__));

if ($argc < 2)
  factXrech::error ("started without required param", 1);

$document = $argv [1];             /* base name (no extension) including path */

/* Create instance and init, collect data for XRechnung template */

$fxr = new factXrech (factXrech::FACTURX, "Europe/Berlin", "$document.CTL");

$vars = array ("ITEMS" => "");                 /* start with no items present */

$fxr->fetch ("0105D20985", $vars, "in ([A-Z]+)", "currencyID");
$fxr->fetch ("0100E200C6", $vars, "(.*)", "HeaderExchangedDocumentName");
$fxr->fetch ("01012D0846", $vars, "(.*)", "DocumentID");
$fxr->fetch ("0101720846", $vars, "(.*)", "IssueDate", factXrech::DATE_FIELD);
$fxr->fetch ("0101B70846", $vars, "(.*)", "ActualDeliveryDate", factXrech::DATE_FIELD);
$fxr->fetch ("0101FC0846", $vars, "(.*)", "PaymentReference");
$fxr->fetch ("0102860846", $vars, "(.*)", "BuyerReference");
$fxr->fetch ("0102410846", $vars, "(.*)", "CustomerID");
$fxr->fetch ("01036C00C6", $vars, "(.*)", "BuyerRegistrationName");
$fxr->fetch ("0103B100C6", $vars, "(.*)", "BuyerStreetName");
$fxr->fetch ("0103F600C6", $vars, "[A-Za-z]*-?([0-9]+) .*", "BuyerPostcodeCode");
$fxr->fetch ("0103F600C6", $vars, "[A-Za-z]*-?[0-9]+ (.*)", "BuyerCityName");
$fxr->fetch ("01043B00C6", $vars, "(.*)", "CountryIC", factXrech::COUNTRY_FIELD);
$fxr->fetch ("010D1A0889", $vars, "([0-9,]+) .*", "TaxableAmount", factXrech::CURRENCY_FIELD);
$fxr->fetch ("010D5F0889", $vars, "([0-9,]+) .*", "TaxAmount", factXrech::CURRENCY_FIELD);
$fxr->fetch ("010DA40889", $vars, "([0-9,]+) .*", "PayableAmount", factXrech::CURRENCY_FIELD);
$fxr->fetch ("010D5F00C6", $vars, ".+ ([0-9,]+)% .*", "TaxPercent");
$fxr->fetch ("01050A0229", $vars, "(.*)", "BuyerEndpointID", factXrech::MAIL_FIELD);

/* Handling of payment is identical for all items */

$vars ["PaymentTerms"] = $fxr->getLine ("010E7300C6");
$vars ["DueDate"] = $fxr->formatDate (substr ($vars ["PaymentTerms"], 29, 10));

$fxr->setIndex ("01063100FD");           /* position to start with item table */

while ($fxr->getIndex () != "010D1A00C6")       /* loop through list of items */
  {
    /* Process list of invoice items, all items have fix VAT and currency */

    $itemvars = array ("currencyID" => $vars ["currencyID"],
                       "TaxPercent" => $vars ["TaxPercent"]);

    $fxr->fetch ("", $itemvars, "(.*)", "LineID");
    $fxr->fetch ("", $itemvars, "(.*)", "SellerAssignedID");
    $fxr->fetch ("", $itemvars, "(.*)", "BuyerAssignedID");
    $fxr->fetch ("", $itemvars, "(.*)", "Name");
    $fxr->fetch ("", $itemvars, "(.*)", "PriceAmount", factXrech::CURRENCY_FIELD);
    $fxr->fetch ("", $itemvars, "(.*)", "UnitCode", factXrech::UNIT_FIELD);
    $fxr->fetch ("", $itemvars, "(.*)", "InvoicedQuantity", factXrech::QUANTITY_FIELD);
    $fxr->fetch ("", $itemvars, "(.*)", "LineExtensionAmount", factXrech::CURRENCY_FIELD);

    $vars ["ITEMS"] .= $fxr->substitute (factXrech::ITEM_TEMPLATE, $itemvars);
  }

/* create and validate xml file using external kosit validator (java) */

$fxr->createXML ($fxr->substitute (factXrech::INVOICE_TEMPLATE, $vars), 1);

if ($fxr->errorsfound () == 0)                   /* nothing went wrong so far */
  {
    $invoicedate = substr ($vars ["IssueDate"], 6, 2) . "." .   /* for humans */
                   substr ($vars ["IssueDate"], 4, 2) . "." .
                   substr ($vars ["IssueDate"], 0, 4);

    $title = "Rechnung {$vars ["DocumentID"]} vom $invoicedate";
    $keywords = "Muster_GmbH {$vars ["DocumentID"]} $invoicedate {$vars ["CustomerID"]}";

    $resultfile = $fxr->createPDF ("$document.pcl", "Muster GmbH", $title, $keywords);

    /* save and rename just generated pdf file */

    copy ($resultfile, "Rechnung_{$vars ["DocumentID"]}_$invoicedate.pdf");
  }

//array_map ('unlink', glob ("$document.*"));         /* uncomment after test */
?>
