﻿<?php
/* E-Mail sending example - call: "C:\php\php.exe" "%1/mail.php" "%1" "%2" %4 */

require "control-class.php";
require "email-class.php";

chdir (dirname(__FILE__));            /* active directory is script directory */

if ($argc < 4)
  control::error ("Invalid number of arguments $argc", 1);

$spool    = $argv [2];                            /* path to spooled document */
$document = $argv [3];                  /* name of document without extension */

$vars = array ();

$p2f = new control ("Europe/Berlin", "$spool\\$document.ctl");

$p2f->fetch ("01012D0846", $vars, "(\d+)", "rechnum");
$p2f->fetch ("0102410846", $vars, "(\d+)", "kndnum");
$p2f->fetch ("01036C00C6", $vars, "(.*)", "kndname");
$p2f->fetch ("01050A0229", $vars, "(.*)", "kndmail");
$p2f->fetch ("0102860846", $vars, ".+ (\d+)", "auftrnum");
$p2f->fetch ("0101720846", $vars, "(\d\d\.\d\d\.\d{4})", "rechdatum");

/* PDF file creation with supplied meta data */

$pdf = $p2f->createPdf ("$spool\\$document.pcl",
                        "Lieferant GmbH",
                        "Rechnung {$vars ["rechnum"]}",
                        "{$vars ["rechnum"]} {$vars ["rechdatum"]} {$vars ["kndnum"]}");

if ($pdf != "")                                    /* pdf creation successful */
  {
    $data = array
      (
        "from"     => "spe@spe-systemhaus.de",
        "fromname" => "Buchhaltung Lieferant GmbH",
        "to"       => "suessmann@spe-systemhaus.de",  // $vars ["kndmail"]
        "toname"   => $vars ["kndname"],
    //  "cc"       => "",
    //  "ccname"   => "",
        "file"     => $pdf,
        "filename" => "Rechnung {$vars ["rechnum"]}.pdf",
        "subject"  => "Lieferant GmbH - Rechnung {$vars ["rechnum"]}",
        "body"     =>

        $p2f->substitute ("Sehr geehrte Damen und Herren,<br/><br/>" .
                          "vielen Dank für Ihren Auftrag @auftrnum@.<br/><br/>" .
                          "Mit dieser Mail erhalten Sie dazu unsere Rechnung @rechnum@<br/>" .
                          "mit Datum vom @rechdatum@ im Format PDF/A.<br/><br/>" .
                          "Mit freundlichen Grüßen<br/>" .
                          "Ihre Lieferant GmbH<br/><br/><br/>" .
                          "Lieferant GmbH<br/>" .
                          "Lieferweg 21<br/>" .
                          "80345 Musterstadt<br/><br/>" .
                          "Tel.: +49 1234 1234-0<br/>" .
                          "Fax:  +49 1234 1234-123<br/><br/>" .
                          "Mail: info@lieferant-gmbh.local<br/><br/>" .
                          "Geschäftsführer: A. Mustermann<br/>" .
                          "Registergericht Musterstadt: 5 HRB 12345<br/>" .
                          "USt-IdNr.: DE123456789<br/>", $vars)
      );

    $em = new email ("server", 465, "user", "password");

    if ($em->sendMail ($data, $message) == 0)
      $p2f->error ("Sending e-mail failed '$message'");
  }
else
  $p2f->error ("No document available for e-mail");

if ($p2f->errorsFound () != 0)
  exit (-1);
?>