/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.tasks;

import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.ScenarioRepository;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.impl.tasks.CheckAction;
import de.kosit.validationtool.model.reportInput.CreateReportInput;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioSelectionAction
implements CheckAction {
    private static final Logger log = LoggerFactory.getLogger(ScenarioSelectionAction.class);
    private final ScenarioRepository repository;

    @Override
    public void check(CheckAction.Bag results) {
        CreateReportInput report = results.getReportInput();
        Result<Scenario, String> scenarioTypeResult = results.getParserResult().isValid() ? this.determineScenario(results.getParserResult().getObject()) : new Result(this.repository.getFallbackScenario());
        results.setScenarioSelectionResult(scenarioTypeResult);
        if (!scenarioTypeResult.getObject().isFallback()) {
            report.setScenario(scenarioTypeResult.getObject().getConfiguration());
            log.info("Scenario {} identified for {}", (Object)scenarioTypeResult.getObject().getName(), (Object)results.getInput().getName());
        } else {
            log.info("No valid scenario configuration found for {}", (Object)results.getInput().getName());
        }
    }

    private Result<Scenario, String> determineScenario(XdmNode document) {
        Result<Scenario, String> result = this.repository.selectScenario(document);
        if (result.isInvalid()) {
            return new Result<Scenario, String>(this.repository.getFallbackScenario());
        }
        return result;
    }

    public ScenarioSelectionAction(ScenarioRepository repository) {
        this.repository = repository;
    }
}

