/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl;

import de.kosit.validationtool.api.Configuration;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.model.Result;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioRepository {
    private static final Logger log = LoggerFactory.getLogger(ScenarioRepository.class);
    public static final String DEFAULT = "default";
    public static final String DEFAULT_ID = "default_1";
    private final List<Configuration> configuration;

    public ScenarioRepository(Configuration ... configuration) {
        if (configuration.length == 0) {
            throw new IllegalArgumentException("Must provide at least one configuration");
        }
        this.configuration = Arrays.asList(configuration);
        this.configuration.forEach(v -> log.info("Loaded scenarios for {} by {} from {}.", v.getName(), v.getAuthor(), v.getDate()));
        log.info("The following scenarios are available:\n{}", (Object)this.summarizeScenarios());
    }

    public Scenario getFallbackScenario() {
        if (this.configuration.size() > 1) {
            log.warn("Multiple configurations found. Using fallback scenario from first configuration");
        }
        return this.configuration.get(0).getFallbackScenario();
    }

    public List<Scenario> getScenarios() {
        return this.configuration.stream().flatMap(c -> c.getScenarios().stream()).collect(Collectors.toList());
    }

    private String summarizeScenarios() {
        StringBuilder b = new StringBuilder();
        this.getScenarios().forEach(s -> {
            b.append(s.getName());
            b.append("\n");
        });
        return b.toString();
    }

    public Result<Scenario, String> selectScenario(XdmNode document) {
        List collect = this.getScenarios().stream().filter(s -> ScenarioRepository.match(document, s)).collect(Collectors.toList());
        Result<Scenario, String> result = collect.size() == 1 ? new Result<Scenario, String>((Scenario)collect.get(0)) : (collect.isEmpty() ? new Result<Scenario, String>(this.getFallbackScenario(), Collections.singleton("None of the loaded scenarios matches the specified document")) : new Result<Scenario, String>(this.getFallbackScenario(), Collections.singleton("More than on scenario matches the specified document")));
        return result;
    }

    private static boolean match(XdmNode document, Scenario scenario) {
        try {
            XPathSelector selector = scenario.getMatchSelector();
            selector.setContextItem(document);
            return selector.effectiveBooleanValue();
        }
        catch (SaxonApiException e) {
            log.error("Error evaluating xpath expression", e);
            return false;
        }
    }
}

