/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.tasks;

import de.kosit.validationtool.api.Input;
import de.kosit.validationtool.impl.CollectingErrorEventHandler;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.input.AbstractInput;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.impl.tasks.CheckAction;
import de.kosit.validationtool.model.reportInput.CreateReportInput;
import de.kosit.validationtool.model.reportInput.ValidationResultsXmlSchema;
import de.kosit.validationtool.model.reportInput.XMLSyntaxError;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SchemaValidationAction
implements CheckAction {
    private static final Logger log = LoggerFactory.getLogger(SchemaValidationAction.class);
    private static final Long BA_LIMIT = 10L;
    private static final String LIMIT_PARAMETER = "schema.validation.inmem.limit";
    private final Processor processor;
    private long inMemoryLimit = Long.parseLong(System.getProperty("schema.validation.inmem.limit", BA_LIMIT.toString())) * 0x100000L;

    private Result<Boolean, XMLSyntaxError> validate(CheckAction.Bag results, Scenario scenario) {
        Result<Boolean, XMLSyntaxError> result;
        block8: {
            log.debug("Validating document using scenario {}", (Object)scenario.getConfiguration().getName());
            CollectingErrorEventHandler errorHandler = new CollectingErrorEventHandler();
            SourceProvider validateInput = this.resolveSource(results);
            try {
                Validator validator = scenario.getFactory().createValidator(scenario.getSchema());
                validator.setErrorHandler(errorHandler);
                validator.validate(validateInput.getSource());
                result = new Result<Boolean, XMLSyntaxError>(!errorHandler.hasErrors(), errorHandler.getErrors());
                if (validateInput == null) break block8;
            }
            catch (Throwable validator) {
                try {
                    if (validateInput != null) {
                        try {
                            validateInput.close();
                        }
                        catch (Throwable throwable) {
                            validator.addSuppressed(throwable);
                        }
                    }
                    throw validator;
                }
                catch (IOException | SaxonApiException | SAXException e) {
                    String msg = String.format("Error processing schema validation for scenario %s", scenario.getConfiguration().getName());
                    log.error(msg, e);
                    results.addProcessingError(msg);
                    return new Result<Boolean, XMLSyntaxError>(Boolean.FALSE);
                }
            }
            validateInput.close();
        }
        return result;
    }

    @Override
    public void check(CheckAction.Bag results) {
        CreateReportInput report = results.getReportInput();
        Scenario scenario = results.getScenarioSelectionResult().getObject();
        Result<Boolean, XMLSyntaxError> validateResult = this.validate(results, scenario);
        results.setSchemaValidationResult(validateResult);
        ValidationResultsXmlSchema result = new ValidationResultsXmlSchema();
        report.setValidationResultsXmlSchema(result);
        result.getResource().addAll(scenario.getConfiguration().getValidateWithXmlSchema().getResource());
        if (!validateResult.isValid()) {
            result.getXmlSyntaxError().addAll(validateResult.getErrors());
        }
    }

    private SourceProvider resolveSource(CheckAction.Bag results) throws IOException, SaxonApiException {
        SourceProvider source = results.getInput() instanceof AbstractInput && ((AbstractInput)results.getInput()).supportsMultipleReads() ? () -> results.getInput().getSource() : this.serialize(results.getInput(), results.getParserResult().getObject());
        return source;
    }

    private SerializedDocument serialize(Input input, XdmNode object) throws IOException, SaxonApiException {
        SerializedDocument doc = input instanceof AbstractInput && ((AbstractInput)input).getLength() < this.getInMemoryLimit() ? new ByteArraySerializedDocument(this.processor) : new FileSerializedDocument(this.processor);
        doc.serialize(object);
        return doc;
    }

    @Override
    public boolean isSkipped(CheckAction.Bag results) {
        return SchemaValidationAction.hasNoSchema(results);
    }

    private static boolean hasNoSchema(CheckAction.Bag results) {
        return results.getScenarioSelectionResult() == null || results.getScenarioSelectionResult().getObject().getSchema() == null;
    }

    public SchemaValidationAction(Processor processor) {
        this.processor = processor;
    }

    void setInMemoryLimit(long inMemoryLimit) {
        this.inMemoryLimit = inMemoryLimit;
    }

    public long getInMemoryLimit() {
        return this.inMemoryLimit;
    }

    private static interface SerializedDocument
    extends AutoCloseable,
    SourceProvider {
        public void serialize(XdmNode var1) throws SaxonApiException, IOException;

        public InputStream openStream() throws IOException;

        @Override
        default public Source getSource() throws IOException {
            return new StreamSource(this.openStream());
        }
    }

    private static interface SourceProvider
    extends AutoCloseable {
        public Source getSource() throws IOException;

        @Override
        default public void close() throws IOException {
        }
    }

    private static class FileSerializedDocument
    implements SerializedDocument {
        private final Path file = Files.createTempFile("validator", ".xml", new FileAttribute[0]);
        private final Processor processor;

        FileSerializedDocument(Processor processor) throws IOException {
            this.processor = processor;
        }

        @Override
        public void serialize(XdmNode node) throws SaxonApiException, IOException {
            try (OutputStream out = Files.newOutputStream(this.file, new OpenOption[0]);){
                Serializer serializer = this.processor.newSerializer();
                serializer.setOutputStream(out);
                serializer.serializeNode(node);
                serializer.close();
            }
        }

        @Override
        public void close() throws IOException {
            Files.deleteIfExists(this.file);
        }

        @Override
        public InputStream openStream() throws IOException {
            return Files.newInputStream(this.file, new OpenOption[0]);
        }
    }

    private static class ByteArraySerializedDocument
    implements SerializedDocument {
        private byte[] bytes;
        private final Processor processor;

        @Override
        public void serialize(XdmNode node) throws SaxonApiException, IOException {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                Serializer serializer = this.processor.newSerializer();
                serializer.setOutputStream(out);
                serializer.serializeNode(node);
                serializer.close();
                this.bytes = out.toByteArray();
            }
        }

        @Override
        public void close() {
        }

        @Override
        public InputStream openStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public ByteArraySerializedDocument(Processor processor) {
            this.processor = processor;
        }
    }
}

