/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.cmd.assertions.AssertionType;
import de.kosit.validationtool.cmd.assertions.Assertions;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.impl.tasks.CheckAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmNode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CheckAssertionAction
implements CheckAction {
    private static final Logger log = LoggerFactory.getLogger(CheckAssertionAction.class);
    private final Assertions assertions;
    private final Processor processor;
    private Map<String, List<AssertionType>> mappedAssertions;

    private static boolean matches(String key, String name) {
        return key.startsWith(name) || (name + ".xml").endsWith(key);
    }

    @Override
    public void check(CheckAction.Bag results) {
        log.info("Checking assertions for {}", (Object)results.getInput().getName());
        List<AssertionType> toCheck = this.findAssertions(results.getName());
        ArrayList errors = new ArrayList();
        if (toCheck != null && !toCheck.isEmpty()) {
            XdmNode node = results.getReport();
            toCheck.forEach(a -> {
                if (!this.check(node, (AssertionType)a)) {
                    log.error("Assertion mismatch: {}", (Object)a.getValue());
                    errors.add(a.getValue());
                }
            });
            if (errors.isEmpty()) {
                log.info("{} assertions successfully verified for {}", (Object)toCheck.size(), (Object)results.getName());
            } else {
                log.warn("{} assertion of {} failed while checking {}", errors.size(), toCheck.size(), results.getName());
            }
            results.setAssertionResult(new Result<Integer, String>(toCheck.size(), errors));
        } else {
            log.warn("Can not find assertions for {}", (Object)results.getName());
        }
    }

    private List<AssertionType> findAssertions(String name) {
        return this.getMapped().entrySet().stream().filter(e -> CheckAssertionAction.matches((String)e.getKey(), name)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private boolean check(XdmNode document, AssertionType assertion) {
        try {
            XPathSelector selector = this.createSelector(assertion);
            selector.setContextItem(document);
            return selector.effectiveBooleanValue();
        }
        catch (SaxonApiException e) {
            log.error("Error evaluating assertion {} for {}", assertion.getTest(), assertion.getReportDoc(), e);
            return false;
        }
    }

    private XPathSelector createSelector(AssertionType assertion) throws SaxonApiException {
        try {
            XPathCompiler compiler = this.getProcessor().newXPathCompiler();
            this.assertions.getNamespace().forEach(ns -> compiler.declareNamespace(ns.getPrefix(), ns.getValue()));
            return compiler.compile(assertion.getTest()).load();
        }
        catch (SaxonApiException e) {
            throw new IllegalStateException(String.format("Can not compile xpath match expression '%s'", StringUtils.isNotBlank(assertion.getTest()) ? assertion.getTest() : "EMPTY EXPRESSION"), e);
        }
    }

    private Map<String, List<AssertionType>> getMapped() {
        if (this.mappedAssertions == null) {
            this.mappedAssertions = new HashMap<String, List<AssertionType>>();
            for (AssertionType assertionType : this.assertions.getAssertion()) {
                List list = this.mappedAssertions.computeIfAbsent(assertionType.getReportDoc(), k -> new ArrayList());
                list.add(assertionType);
            }
        }
        return this.mappedAssertions;
    }

    public CheckAssertionAction(Assertions assertions, Processor processor) {
        this.assertions = assertions;
        this.processor = processor;
    }

    private Processor getProcessor() {
        return this.processor;
    }
}

