/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.config;

import de.kosit.validationtool.api.Configuration;
import de.kosit.validationtool.api.ResolvingConfigurationStrategy;
import de.kosit.validationtool.config.DefaultConfiguration;
import de.kosit.validationtool.config.FallbackBuilder;
import de.kosit.validationtool.config.ReportBuilder;
import de.kosit.validationtool.config.ScenarioBuilder;
import de.kosit.validationtool.config.SchemaBuilder;
import de.kosit.validationtool.config.SchematronBuilder;
import de.kosit.validationtool.impl.ContentRepository;
import de.kosit.validationtool.impl.DateFactory;
import de.kosit.validationtool.impl.ResolvingMode;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.model.scenarios.DescriptionType;
import de.kosit.validationtool.model.scenarios.NoScenarioReportType;
import de.kosit.validationtool.model.scenarios.ObjectFactory;
import de.kosit.validationtool.model.scenarios.Scenarios;
import java.net.URI;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.validation.Schema;
import net.sf.saxon.s9api.Processor;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationBuilder.class);
    private final List<ScenarioBuilder> scenarios = new ArrayList<ScenarioBuilder>();
    private FallbackBuilder fallbackBuilder;
    private ResolvingConfigurationStrategy resolvingConfigurationStrategy;
    private ResolvingMode resolvingMode = ResolvingMode.STRICT_RELATIVE;
    private String author = "API";
    private String date = LocalDate.now().toString();
    private String name = "Custom";
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private URI repository;
    private String description;

    public ConfigurationBuilder author(String authorName) {
        this.author = authorName;
        return this;
    }

    public ConfigurationBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ConfigurationBuilder date(LocalDate date) {
        if (date != null) {
            this.date = date.toString();
        }
        return this;
    }

    public ConfigurationBuilder date(Date date) {
        return this.date(date != null ? date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : null);
    }

    public ConfigurationBuilder with(ScenarioBuilder scenarioBuilder) {
        this.scenarios.add(scenarioBuilder);
        return this;
    }

    public ConfigurationBuilder with(FallbackBuilder builder) {
        if (this.fallbackBuilder != null) {
            log.warn("Overriding previously created fallback scenario");
        }
        this.fallbackBuilder = builder;
        return this;
    }

    public ConfigurationBuilder description(String description) {
        this.description = description;
        return this;
    }

    public static FallbackBuilder fallback() {
        return new FallbackBuilder();
    }

    public static FallbackBuilder defaultFallback() {
        throw new NotImplementedException("Not yet defined");
    }

    public static SchematronBuilder schematron(String name) {
        return new SchematronBuilder().name(name);
    }

    public static SchemaBuilder schema() {
        return new SchemaBuilder();
    }

    public static SchemaBuilder schema(String name, Schema schema) {
        return new SchemaBuilder().name(name).schema(schema);
    }

    public static SchemaBuilder schema(String name) {
        return new SchemaBuilder().name(name);
    }

    public static SchemaBuilder schema(URI uri) {
        return new SchemaBuilder().schemaLocation(uri);
    }

    public static ScenarioBuilder scenario(String name) {
        return new ScenarioBuilder().name(name);
    }

    public static ScenarioBuilder scenario() {
        return ConfigurationBuilder.scenario(null);
    }

    public static ReportBuilder report(String name) {
        return new ReportBuilder().name(name);
    }

    public Configuration build(Processor processor) {
        ResolvingConfigurationStrategy resolving = this.getResolvingConfigurationStrategy();
        ContentRepository contentRepository = new ContentRepository(processor, resolving, this.repository);
        List<Scenario> list = this.initializeScenarios(contentRepository);
        Scenario fallbackScenario = this.initializeFallback(contentRepository);
        DefaultConfiguration configuration = new DefaultConfiguration(list, fallbackScenario);
        configuration.setAdditionalParameters(this.parameters);
        configuration.setAuthor(this.author);
        configuration.setDate(this.date);
        configuration.setName(this.name);
        configuration.setContentRepository(contentRepository);
        configuration.getAdditionalParameters().put("scenario_definition", this.createDefinition(configuration));
        return configuration;
    }

    private Scenarios createDefinition(DefaultConfiguration configuration) {
        Scenarios s = new Scenarios();
        s.setAuthor(configuration.getAuthor());
        s.setDate(DateFactory.createTimestamp());
        DescriptionType d = new DescriptionType();
        d.getPOrOlOrUl().add(new ObjectFactory().createDescriptionTypeP(StringUtils.defaultIfBlank(this.description, "")));
        s.setDescription(d);
        s.setName(configuration.getName());
        s.getScenario().addAll(configuration.getScenarios().stream().map(Scenario::getConfiguration).collect(Collectors.toList()));
        s.setNoScenarioReport(ConfigurationBuilder.createNoScenarioReportType(configuration.getFallbackScenario()));
        return s;
    }

    private static NoScenarioReportType createNoScenarioReportType(Scenario fallbackScenario) {
        NoScenarioReportType no = new NoScenarioReportType();
        no.setResource(fallbackScenario.getConfiguration().getCreateReport().getResource());
        return no;
    }

    private Scenario initializeFallback(ContentRepository contentRepository) {
        if (this.fallbackBuilder == null) {
            throw new IllegalStateException("No fallback configuration specified");
        }
        Result<Scenario, String> result = this.fallbackBuilder.build(contentRepository);
        if (result.isInvalid()) {
            throw new IllegalStateException("Invalid fallback configuration: " + String.join((CharSequence)",", result.getErrors()));
        }
        return result.getObject();
    }

    private List<Scenario> initializeScenarios(ContentRepository contentRepository) {
        if (this.scenarios.isEmpty()) {
            throw new IllegalStateException("No scenario specified");
        }
        return this.scenarios.stream().map(s -> {
            Result<Scenario, String> result = s.build(contentRepository);
            if (result.isInvalid()) {
                String msg = String.join((CharSequence)",", result.getErrors());
                throw new IllegalStateException(String.format("Invalid configuration for scenario %s found: %s", s.getName(), msg));
            }
            return result.getObject();
        }).collect(Collectors.toList());
    }

    private ResolvingConfigurationStrategy getResolvingConfigurationStrategy() {
        if (this.resolvingConfigurationStrategy != null) {
            log.info("Custom resolving strategy supplied. Please take care of xml security!");
            return this.resolvingConfigurationStrategy;
        }
        log.info("Using resolving strategy {}", (Object)this.resolvingMode);
        return this.resolvingMode.getStrategy();
    }

    public ConfigurationBuilder resolvingMode(ResolvingMode mode) {
        this.resolvingMode = mode;
        return this;
    }

    public ConfigurationBuilder resolvingStrategy(ResolvingConfigurationStrategy strategy) {
        this.resolvingConfigurationStrategy = strategy;
        return this;
    }

    public ConfigurationBuilder useRepository(URI repository) {
        this.repository = repository;
        return this;
    }

    public ConfigurationBuilder useRepository(Path repository) {
        return this.useRepository(repository.toUri());
    }

    List<ScenarioBuilder> getScenarios() {
        return this.scenarios;
    }

    FallbackBuilder getFallbackBuilder() {
        return this.fallbackBuilder;
    }

    ResolvingMode getResolvingMode() {
        return this.resolvingMode;
    }

    String getAuthor() {
        return this.author;
    }

    String getDate() {
        return this.date;
    }

    String getName() {
        return this.name;
    }

    Map<String, Object> getParameters() {
        return this.parameters;
    }

    URI getRepository() {
        return this.repository;
    }

    String getDescription() {
        return this.description;
    }
}

