/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.config;

import de.kosit.validationtool.api.Configuration;
import de.kosit.validationtool.api.InputFactory;
import de.kosit.validationtool.api.ResolvingConfigurationStrategy;
import de.kosit.validationtool.config.DefaultConfiguration;
import de.kosit.validationtool.config.FallbackBuilder;
import de.kosit.validationtool.impl.CollectingErrorEventHandler;
import de.kosit.validationtool.impl.ContentRepository;
import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.impl.ResolvingMode;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.SchemaProvider;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.impl.tasks.DocumentParseAction;
import de.kosit.validationtool.impl.xml.RelativeUriResolver;
import de.kosit.validationtool.model.reportInput.XMLSyntaxError;
import de.kosit.validationtool.model.scenarios.ResourceType;
import de.kosit.validationtool.model.scenarios.ScenarioType;
import de.kosit.validationtool.model.scenarios.Scenarios;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.validation.Schema;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationLoader {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationLoader.class);
    private static final String SUPPORTED_MAJOR_VERSION = "1";
    private static final String SUPPORTED_MAJOR_VERSION_SCHEMA = "http://www.xoev.de/de/validator/framework/1/scenarios";
    protected final Map<String, Object> parameters = new HashMap<String, Object>();
    private final URI scenarioDefinition;
    private final URI scenarioRepository;
    protected ResolvingMode resolvingMode = ResolvingMode.STRICT_RELATIVE;
    protected ResolvingConfigurationStrategy resolvingConfigurationStrategy;

    private static void checkVersion(URI scenarioDefinition, Processor processor) {
        try {
            Result<XdmNode, XMLSyntaxError> result = new DocumentParseAction(processor).parseDocument(InputFactory.read(scenarioDefinition.toURL()));
            if (result.isValid() && !ConfigurationLoader.isSupportedDocument(result.getObject())) {
                throw new IllegalStateException(String.format("Specified scenario configuration %s is not supported.%nThis version only supports definitions of '%s'", scenarioDefinition, SUPPORTED_MAJOR_VERSION_SCHEMA));
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Error reading definition file");
        }
    }

    private static XdmNode findRoot(XdmNode doc) {
        for (XdmNode node : doc.children()) {
            if (node.getNodeKind() != XdmNodeKind.ELEMENT) continue;
            return node;
        }
        throw new IllegalArgumentException("Kein root element gefunden");
    }

    private static boolean isSupportedDocument(XdmNode doc) {
        XdmNode root = ConfigurationLoader.findRoot(doc);
        String frameworkVersion = root.getAttributeValue(new QName("frameworkVersion"));
        return StringUtils.startsWith(frameworkVersion, SUPPORTED_MAJOR_VERSION) && root.getNodeName().getNamespaceURI().equals(SUPPORTED_MAJOR_VERSION_SCHEMA);
    }

    private static Scenario createFallback(Scenarios scenarios, ContentRepository repository) {
        ResourceType noscenarioResource = scenarios.getNoScenarioReport().getResource();
        return new FallbackBuilder().source(noscenarioResource.getLocation()).name(noscenarioResource.getName()).build(repository).getObject();
    }

    private static List<Scenario> initializeScenarios(Scenarios def, ContentRepository contentRepository) {
        return def.getScenario().stream().map(s -> ConfigurationLoader.initialize(s, contentRepository)).collect(Collectors.toList());
    }

    private static Scenario initialize(ScenarioType def, ContentRepository repository) {
        Scenario s = new Scenario(def);
        s.setMatchExecutable(repository.createMatchExecutable(def));
        s.setSchema(repository.createSchema(def));
        s.setSchematronValidations(repository.createSchematronTransformations(def));
        if (def.getCreateReport() != null) {
            s.setReportTransformation(repository.createReportTransformation(def));
        } else {
            log.warn("No report configured. Will provide an internal format as report!");
            s.setReportTransformation(repository.createIdentityTransformation());
        }
        s.setFactory(repository.getResolvingConfigurationStrategy());
        s.setUriResolver(repository.getResolver());
        s.setUnparsedTextURIResolver(repository.getUnparsedTextURIResolver());
        if (def.getAcceptMatch() != null) {
            s.setAcceptExecutable(repository.createAccepptExecutable(def));
        }
        return s;
    }

    URI getScenarioRepository() {
        if (this.scenarioRepository == null) {
            log.info("Creating default scenario repository (alongside scenario definition)");
            return RelativeUriResolver.resolve(URI.create("."), this.scenarioDefinition);
        }
        return this.scenarioRepository;
    }

    public Configuration build(Processor processor) {
        ResolvingConfigurationStrategy resolving = this.getResolvingConfigurationStrategy();
        ContentRepository contentRepository = new ContentRepository(processor, resolving, this.getScenarioRepository());
        Scenarios def = this.loadScenarios(SchemaProvider.getScenarioSchema(), processor);
        List<Scenario> scenarios = ConfigurationLoader.initializeScenarios(def, contentRepository);
        Scenario fallbackScenario = ConfigurationLoader.createFallback(def, contentRepository);
        DefaultConfiguration configuration = new DefaultConfiguration(scenarios, fallbackScenario);
        configuration.setAdditionalParameters(this.parameters);
        configuration.setAuthor(def.getAuthor());
        configuration.setDate(def.getDate().toString());
        configuration.setName(def.getName());
        configuration.setContentRepository(contentRepository);
        configuration.getAdditionalParameters().put("scenarios_file", this.scenarioDefinition);
        configuration.getAdditionalParameters().put("scenario_definition", def);
        return configuration;
    }

    private ResolvingConfigurationStrategy getResolvingConfigurationStrategy() {
        if (this.resolvingConfigurationStrategy != null) {
            log.info("Custom resolving strategy supplied. Please take care of xml security!");
            return this.resolvingConfigurationStrategy;
        }
        log.info("Using resolving strategy {}", (Object)this.resolvingMode);
        return this.resolvingMode.getStrategy();
    }

    private Scenarios loadScenarios(Schema scenarioSchema, Processor processor) {
        ConfigurationLoader.checkVersion(this.scenarioDefinition, processor);
        log.info("Loading scenarios from {}", (Object)this.scenarioDefinition);
        CollectingErrorEventHandler handler = new CollectingErrorEventHandler();
        ConversionService conversionService = new ConversionService();
        Scenarios scenarios = conversionService.readXml(this.scenarioDefinition, Scenarios.class, scenarioSchema, handler);
        if (handler.hasErrors()) {
            throw new IllegalStateException(String.format("Can not load scenarios from %s due to %s", this.getScenarioDefinition(), handler.getErrorDescription()));
        }
        log.info("Loading scenario content from {}", (Object)this.getScenarioRepository());
        return scenarios;
    }

    public ConfigurationLoader setResolvingMode(ResolvingMode mode) {
        if (this.resolvingConfigurationStrategy != null) {
            log.warn("Ignoring resolving mode configuration since a custom strategy is already defined");
        }
        this.resolvingMode = mode;
        return this;
    }

    public ConfigurationLoader setResolvingStrategy(ResolvingConfigurationStrategy strategy) {
        this.resolvingConfigurationStrategy = strategy;
        return this;
    }

    public ConfigurationLoader addParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public ConfigurationLoader(URI scenarioDefinition, URI scenarioRepository) {
        this.scenarioDefinition = scenarioDefinition;
        this.scenarioRepository = scenarioRepository;
    }

    URI getScenarioDefinition() {
        return this.scenarioDefinition;
    }
}

