/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.model;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.oclc.purl.dsdl.svrl.ActivePattern;
import org.oclc.purl.dsdl.svrl.FailedAssert;
import org.oclc.purl.dsdl.svrl.FiredRule;

public abstract class BaseOutput {
    public abstract List<Serializable> getActivePatternAndFiredRuleAndFailedAssert();

    public List<FailedAssert> getFailedAsserts() {
        return this.filter(FailedAssert.class);
    }

    public List<FiredRule> getFiredRules() {
        return this.filter(FiredRule.class);
    }

    public boolean hasFailedAsserts() {
        return !this.getFailedAsserts().isEmpty();
    }

    public List<ActivePattern> getActivePatterns() {
        return this.filter(ActivePattern.class);
    }

    private <T> List<T> filter(Class<T> type) {
        return this.getActivePatternAndFiredRuleAndFailedAssert().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    public Optional<FailedAssert> findFailedAssert(String name) {
        return this.getFailedAsserts().stream().filter((? super T e) -> e.getId().equals(name)).findAny();
    }

    public List<String> getMessages() {
        return this.getFailedAsserts().stream().map(FailedAssert::getText).flatMap(e -> e.getContent().stream()).map(Object::toString).collect(Collectors.toList());
    }
}

