/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl;

import de.kosit.validationtool.impl.ResolvingMode;
import de.kosit.validationtool.impl.xml.ClassPathResourceResolver;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class SchemaProvider {
    private static Schema reportInputSchema;

    public static Schema getReportInputSchema() {
        if (reportInputSchema == null) {
            SchemaFactory sf = ResolvingMode.STRICT_RELATIVE.getStrategy().createSchemaFactory();
            Source source = SchemaProvider.resolve(SchemaProvider.class.getResource("/xsd/createReportInput.xsd"));
            reportInputSchema = SchemaProvider.createSchema(sf, new Source[]{source}, new ClassPathResourceResolver("/xsd"));
        }
        return reportInputSchema;
    }

    private static Schema createSchema(SchemaFactory sf, Source[] schemaSources, LSResourceResolver resourceResolver) {
        try {
            sf.setResourceResolver(resourceResolver);
            return sf.newSchema(schemaSources);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Can not load schema from sources " + schemaSources[0].getSystemId(), e);
        }
    }

    private static Schema createSchema(SchemaFactory sf, Source ... schemaSources) {
        return SchemaProvider.createSchema(sf, schemaSources, null);
    }

    private static Source resolve(URL resource) {
        try {
            String rawPath = resource.toURI().getRawPath();
            return new StreamSource(resource.openStream(), rawPath);
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException("Can not load schema for resource " + resource.getPath(), e);
        }
    }

    public static Schema getScenarioSchema() {
        SchemaFactory sf = ResolvingMode.STRICT_RELATIVE.getStrategy().createSchemaFactory();
        return SchemaProvider.createSchema(sf, SchemaProvider.resolve(SchemaProvider.class.getResource("/xsd/scenarios.xsd")));
    }
}

