/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.impl.HtmlExtractor;
import de.kosit.validationtool.impl.tasks.CheckAction;
import java.nio.file.Path;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtractHtmlContentAction
implements CheckAction {
    private static final Logger log = LoggerFactory.getLogger(ExtractHtmlContentAction.class);
    private static final QName NAME_ATTRIBUTE = new QName("data-report-type");
    private final Path outputDirectory;
    private HtmlExtractor htmlExtraction;
    private Processor processor;

    public ExtractHtmlContentAction(Processor p, Path outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.htmlExtraction = new HtmlExtractor(p);
        this.processor = p;
    }

    @Override
    public void check(CheckAction.Bag results) {
        this.htmlExtraction.extract(results.getReport()).forEach(i -> this.print(results.getName(), (XdmItem)i));
    }

    private void print(String origName, XdmItem xdmItem) {
        XdmNode node = (XdmNode)xdmItem;
        String name = origName + "-" + node.getAttributeValue(NAME_ATTRIBUTE);
        Path file = this.outputDirectory.resolve(name + ".html");
        Serializer serializer = this.processor.newSerializer(file.toFile());
        try {
            log.info("Writing report html '{}' to {}", (Object)name, (Object)file.toAbsolutePath());
            serializer.serializeNode(node);
        }
        catch (SaxonApiException e) {
            log.error("Error extracting html content to {}", (Object)file.toAbsolutePath(), (Object)e);
        }
    }

    @Override
    public boolean isSkipped(CheckAction.Bag results) {
        if (results.getReport() == null) {
            log.warn("Can not extract html content. No report document found");
            return true;
        }
        return false;
    }

    public ExtractHtmlContentAction(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

