/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.impl.tasks.CheckAction;
import java.text.NumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrintMemoryStats
implements CheckAction {
    private static final Logger log = LoggerFactory.getLogger(PrintMemoryStats.class);
    private static final int BYTES_PER_K = 1024;

    PrintMemoryStats() {
    }

    @Override
    public void check(CheckAction.Bag results) {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        NumberFormat format = NumberFormat.getInstance();
        String freeStr = format.format(freeMemory / 1024L);
        String allocStr = format.format(allocatedMemory / 1024L);
        String maxStr = format.format(maxMemory / 1024L);
        String totalFreeStr = format.format((freeMemory + (maxMemory - allocatedMemory)) / 1024L);
        log.info("free memory: {}MB; allocated memory: {}MB", (Object)freeStr, (Object)allocStr);
        log.info("max memory: {}MB; total free memory: {}MB", (Object)maxStr, (Object)totalFreeStr);
    }
}

