/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.impl.tasks.CheckAction;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeReportInputAction
implements CheckAction {
    private static final Logger log = LoggerFactory.getLogger(SerializeReportInputAction.class);
    private final Path outputDirectory;
    private final ConversionService conversionService;

    @Override
    public void check(CheckAction.Bag results) {
        Path file = this.outputDirectory.resolve(results.getName() + "-reportInput.xml");
        try {
            log.info("Serializing result to {}", (Object)file.toAbsolutePath());
            String xml = this.conversionService.writeXml(results.getReportInput());
            Files.write(file, xml.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("Can not serialize result report to {}", (Object)file.toAbsolutePath(), (Object)e);
        }
    }

    @Override
    public boolean isSkipped(CheckAction.Bag results) {
        if (results.getReportInput() == null) {
            log.warn("Can not serialize  report input. No object found");
            return true;
        }
        return false;
    }

    public SerializeReportInputAction(Path outputDirectory, ConversionService conversionService) {
        this.outputDirectory = outputDirectory;
        this.conversionService = conversionService;
    }
}

