/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.config;

import de.kosit.validationtool.config.Builder;
import de.kosit.validationtool.impl.ContentRepository;
import de.kosit.validationtool.impl.model.Result;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.sf.saxon.s9api.XPathExecutable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XPathBuilder
implements Builder<XPathExecutable> {
    private static final Logger log = LoggerFactory.getLogger(XPathBuilder.class);
    private static final String[] IGNORED_PREFIXES = new String[]{"xsd", "saxon", "xsl", "xs", "xml"};
    private final String name;
    private String xpath;
    private XPathExecutable executable;
    private Map<String, String> namespaces;

    private static Result<XPathExecutable, String> createError(String msg) {
        return new Result<Object, String>(null, Collections.singletonList(msg));
    }

    Map<String, String> getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        return this.namespaces;
    }

    public String getXPath() {
        return this.xpath == null && this.executable != null ? this.executable.getUnderlyingExpression().getInternalExpression().toString() : this.xpath;
    }

    public boolean isAvailable() {
        return this.executable != null || ObjectUtils.isNotEmpty(this.xpath);
    }

    @Override
    public Result<XPathExecutable, String> build(ContentRepository repository) {
        if (!this.isAvailable()) {
            return XPathBuilder.createError(String.format("No configuration for %s xpath  expression found", this.name));
        }
        try {
            if (this.executable == null) {
                this.executable = repository.createXPath(this.xpath, this.getNamespaces());
            } else {
                this.xpath = this.extractExpression();
                this.extractNamespaces();
            }
        }
        catch (IllegalStateException e) {
            String msg = String.format("Error creating %s xpath: %s", this.name, e.getMessage());
            log.error(msg, e);
            return new Result(Collections.singletonList(msg));
        }
        return new Result<XPathExecutable, String>(this.executable);
    }

    private void extractNamespaces() {
        HashMap ns = new HashMap();
        Iterator<String> iterator = this.executable.getUnderlyingExpression().getInternalExpression().getRetainedStaticContext().iteratePrefixes();
        Iterable iterable = () -> iterator;
        StreamSupport.stream(iterable.spliterator(), false).filter(e -> !ArrayUtils.contains(IGNORED_PREFIXES, e)).filter(StringUtils::isNotBlank).forEach(e -> ns.put(e, this.executable.getUnderlyingExpression().getInternalExpression().getRetainedStaticContext().getURIForPrefix((String)e, false)));
        this.getNamespaces().putAll(ns);
    }

    private String extractExpression() {
        return this.executable.getUnderlyingExpression().getInternalExpression().toString();
    }

    public XPathBuilder(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public XPathExecutable getExecutable() {
        return this.executable;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public void setExecutable(XPathExecutable executable) {
        this.executable = executable;
    }

    void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }
}

