/*
 * Decompiled with CFR 0.152.
 */
package de.print2forms.ZUGFeRD;

import de.print2forms.ZUGFeRD.PDFA1Strategy;
import de.print2forms.ZUGFeRD.ZUGFeRDStrategy;
import de.print2forms.util.KeyCheck4J.KeyCheck4J;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.xmpbox.type.BadFieldValueException;

public final class Main {
    private static final int authMode = 33;

    private Main() {
    }

    public static void showHelp(OptionParser parser) {
        try {
            parser.printHelpOn(System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws JAXBException, IOException, TransformerException, BadFieldValueException {
        OptionParser parser = new OptionParser();
        parser.accepts("xml").withRequiredArg().required().ofType(String.class).describedAs("Path to ZUGFeRD-XML-File to attach");
        parser.accepts("inpdf").withRequiredArg().ofType(String.class).describedAs("Path to PDF/A-1 compatible invoice pdf file");
        parser.accepts("outpdf").withRequiredArg().required().ofType(String.class).describedAs("Path to output the created ZUGFeRD compatible pdf");
        parser.accepts("key").withRequiredArg().required().ofType(String.class).describedAs("The license key generated by a print2forms gateway authorizing p2fZugferd to be run.");
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (Exception e) {
            Main.showHelp(parser);
            return;
        }
        PDFA1Strategy strat = null;
        if (!options.has("key")) {
            System.err.println("Key (--key) missing");
            Main.showHelp(parser);
            return;
        }
        String key = (String)options.valueOf("key");
        KeyCheck4J keyChecker = new KeyCheck4J();
        try {
            if (!keyChecker.check(key, 33)) {
                System.err.println("Invalid Key");
                return;
            }
        }
        catch (Exception e) {
            System.err.println("Invalid Key");
            return;
        }
        strat = new PDFA1Strategy(options.valueOf("inpdf").toString(), options.valueOf("xml").toString());
        ((ZUGFeRDStrategy)strat).convert(options.valueOf("outpdf").toString());
    }
}

