/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.pdfparser.COSParser;

public class FDFParser
extends COSParser {
    private static final Log LOG = LogFactory.getLog(FDFParser.class);

    public FDFParser(String filename) throws IOException {
        this(new File(filename));
    }

    public FDFParser(File file) throws IOException {
        super(new RandomAccessFile(file, "r"));
        this.fileLen = file.length();
        this.init();
    }

    public FDFParser(InputStream input) throws IOException {
        super(new RandomAccessBuffer(input));
        this.fileLen = this.source.length();
        this.init();
    }

    private void init() throws IOException {
        String eofLookupRangeStr = System.getProperty("org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange");
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                LOG.warn("System property org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'");
            }
        }
        this.document = new COSDocument();
    }

    private void initialParse() throws IOException {
        COSBase rootObject;
        COSDictionary trailer = null;
        long startXRefOffset = this.getStartxrefOffset();
        boolean rebuildTrailer = false;
        if (startXRefOffset > 0L) {
            try {
                trailer = this.parseXref(startXRefOffset);
            }
            catch (IOException exception) {
                if (this.isLenient()) {
                    rebuildTrailer = true;
                }
                throw exception;
            }
        } else if (this.isLenient()) {
            rebuildTrailer = true;
        }
        if (rebuildTrailer) {
            trailer = this.rebuildTrailer();
        }
        if ((rootObject = this.parseTrailerValuesDynamically(trailer)) instanceof COSDictionary) {
            this.parseDictObjects((COSDictionary)rootObject, null);
        }
        this.initialParseDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        boolean exceptionOccurred = true;
        try {
            if (!this.parseFDFHeader()) {
                throw new IOException("Error: Header doesn't contain versioninfo");
            }
            this.initialParse();
            exceptionOccurred = false;
        }
        finally {
            if (exceptionOccurred && this.document != null) {
                IOUtils.closeQuietly(this.document);
                this.document = null;
            }
        }
    }
}

