<?php

/*  ZUGFeRD Support Version 3.0     (c) 2019 SPE Systemhaus GmbH  */

require("zugferd-class.php");

chdir (dirname(__FILE__));
if ($argc < 3 || strlen ($argv [2]) < 1)
    ZUGFeRD::error ("started without required params." );

$document = $argv [1];             /* base name (no extension) including path */

if (! file_exists("$document.pcl"))
    ZUGFeRD::error ("$document.pcl file not found.");

/* Collect data for template comfort.xml */

$zf = new ZUGFeRD ("de", $document . ".CTL");     /* create instance and init */

$vars = array ("ITEMS" => "");                 /* start with no items present */

$zf->fetch ("0105D20985", $vars, "in ([A-Z]+)", "currencyID");
$zf->fetch ("0100E200C6", $vars, "(.*)", "HeaderExchangedDocumentName");
$zf->fetch ("01012D0846", $vars, "(.*)", "HeaderExchangedDocumentID");
$zf->fetch ("0101720846", $vars, "(.*)", "IssueDateTime", ZUGFeRD::DATE_FIELD);
$zf->fetch ("0101B70846", $vars, "(.*)", "OccurrenceDateTime", ZUGFeRD::DATE_FIELD);
$zf->fetch ("0101FC0846", $vars, "(.*)", "PaymentReference");
$zf->fetch ("0102860846", $vars, "(.*)", "CustomerReference");   /* just info */
$zf->fetch ("0102410846", $vars, "(.*)", "CustomerID");          /* just info */
$zf->fetch ("01036C00C6", $vars, "(.*)", "BuyerTradePartyName");
$zf->fetch ("0103B100C6", $vars, "(.*)", "LineOne");
$zf->fetch ("0103F600C6", $vars, "[A-Za-z]*-?([0-9]+) .*", "PostcodeCode");
$zf->fetch ("0103F600C6", $vars, "[A-Za-z]*-?[0-9]+ (.*)", "CityName");
$zf->fetch ("01043B00C6", $vars, "(.*)", "CountryID", ZUGFeRD::COUNTRY_FIELD);
$zf->fetch ("010D1A0889", $vars, "([0-9,]+) .*", "BasisAmount", ZUGFeRD::CURRENCY_FIELD);
$zf->fetch ("010D5F0889", $vars, "([0-9,]+) .*", "TaxTotalAmount", ZUGFeRD::CURRENCY_FIELD);
$zf->fetch ("010DA40889", $vars, "([0-9,]+) .*", "GrandTotalAmount", ZUGFeRD::CURRENCY_FIELD);
$zf->fetch ("010D5F00C6", $vars, ".+ ([0-9,]+)% .*", "ApplicablePercent");

/* Special handling of payment information */

$vars ["SpecifiedTradePaymentTerms"] = $zf->getLine ("010E7300C6");
$vars ["DueDateDateTime"] = $zf->formatDate (substr ($vars ["SpecifiedTradePaymentTerms"], 29, 10));

$zf->setIndex ("01063100FD");              /* position to start of item table */

while ($zf->getIndex () != "010D1A00C6") {      /* loop through list of items */
    
    /* walk through line in list of items */

    $itemvars = array ("currencyID" => $vars ["currencyID"],
                       "ApplicablePercent" => $vars ["ApplicablePercent"]);

    $zf->fetch ("", $itemvars, "(.*)", "LineID");
    $zf->fetch ("", $itemvars, "(.*)", "SellerAssignedID");
    $zf->fetch ("", $itemvars, "(.*)", "BuyerAssignedID");
    $zf->fetch ("", $itemvars, "(.*)", "Name");
    $zf->fetch ("", $itemvars, "(.*)", "ChargeAmount", ZUGFeRD::CURRENCY_FIELD);
    $zf->fetch ("", $itemvars, "(.*)", "unitCode", ZUGFeRD::UNIT_FIELD);
    $zf->fetch ("", $itemvars, "(.*)", "BilledQuantity", ZUGFeRD::QUANTITY_FIELD);
    $zf->fetch ("", $itemvars, "(.*)", "LineTotalAmount", ZUGFeRD::CURRENCY_FIELD);

    $vars["ITEMS"] .= $zf->substitute (ZUGFeRD::ITEM_TEMPLATE, $itemvars);
}

file_put_contents ("$document.xml", $zf->substitute (ZUGFeRD::BASIC_TEMPLATE, $vars));

system ("\"converter/gpcl6win32.exe\" \"-o$document.temp.pdf\" " .
                 "-sPDFCompatibillityPolicy=2 -sDEVICE=pdfwrite -dPDFA=1 " .
                 "-dCompressPages=false -dCompressFonts=false \"$document.pcl\"");

system ("java -jar \"p2fzugferd/p2fzugferd.jar\" --inpdf \"$document.temp.pdf\" " .
            "--xml \"$document.xml\" --outpdf \"" . dirname ($document) . "/" . 
            $vars ["HeaderExchangedDocumentName"] . "_" . 
            $vars ["HeaderExchangedDocumentID"] . ".pdf\" --key \"" . $argv [2] . "\"");

//array_map ('unlink', glob ("$document.*"));         /* uncomment after test */
